/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.items;

import com.hollingsworth.arsnouveau.api.util.SourceUtil;
import com.hollingsworth.arsnouveau.common.items.ModItem;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.ItemsRegistry;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec2;

public class WarpScroll
extends ModItem {
    public WarpScroll() {
        super(ItemsRegistry.defaultItemProperties(), "warp_scroll");
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!stack.m_41782_()) {
            stack.m_41751_(new CompoundTag());
        }
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        if (!entity.m_20193_().f_46443_) {
            String displayName;
            String string = displayName = stack.m_41788_() ? stack.m_41786_().getString() : "";
            if (WarpScroll.getPos(stack) != BlockPos.f_121853_ && this.getDimension(stack).equals(entity.m_20193_().m_46472_().getRegistryName().toString()) && SourceUtil.hasSourceNearby(entity.m_142538_(), entity.m_20193_(), 10, 9000) && (BlockRegistry.PORTAL_BLOCK.trySpawnPortal((LevelAccessor)entity.m_20193_(), entity.m_142538_(), WarpScroll.getPos(stack), this.getDimension(stack), WarpScroll.getRotationVector(stack), displayName) || BlockRegistry.PORTAL_BLOCK.trySpawnHoriztonalPortal(entity.m_20193_(), entity.m_142538_(), WarpScroll.getPos(stack), this.getDimension(stack), WarpScroll.getRotationVector(stack), displayName)) && SourceUtil.takeSourceNearbyWithParticles(entity.m_142538_(), entity.m_20193_(), 10, 9000) != null) {
                BlockPos pos = entity.m_142538_();
                ServerLevel world = (ServerLevel)entity.m_20193_();
                world.m_8767_((ParticleOptions)ParticleTypes.f_123760_, (double)pos.m_123341_(), (double)(pos.m_123342_() + 1), (double)pos.m_123343_(), 10, (world.f_46441_.nextDouble() - 0.5) * 2.0, -world.f_46441_.nextDouble(), (world.f_46441_.nextDouble() - 0.5) * 2.0, (double)0.1f);
                world.m_5594_(null, pos, SoundEvents.f_12049_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                stack.m_41774_(1);
                return true;
            }
        }
        return false;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        BlockPos pos = WarpScroll.getPos(stack);
        if (hand == InteractionHand.OFF_HAND) {
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        if (world.m_5776_()) {
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        if (!pos.equals((Object)BlockPos.f_121853_)) {
            if (this.getDimension(stack) == null || !this.getDimension(stack).equals(player.m_20193_().m_46472_().getRegistryName().toString())) {
                player.m_6352_((Component)new TranslatableComponent("ars_nouveau.warp_scroll.wrong_dim"), Util.f_137441_);
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            player.m_20324_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5);
            Vec2 rotation = WarpScroll.getRotationVector(stack);
            player.f_19858_ = rotation.f_82470_;
            player.f_19857_ = rotation.f_82471_;
            stack.m_41774_(1);
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        if (player.m_6144_()) {
            boolean didAdd;
            ItemStack newWarpStack = new ItemStack((ItemLike)ItemsRegistry.WARP_SCROLL);
            newWarpStack.m_41751_(new CompoundTag());
            this.setTeleportTag(newWarpStack, player.m_142538_(), player.m_20193_().m_46472_().getRegistryName().toString());
            WarpScroll.setRotationVector(newWarpStack, player.m_20155_());
            if (stack.m_41613_() == 1) {
                stack = newWarpStack;
                didAdd = true;
            } else {
                didAdd = player.m_36356_(newWarpStack);
                if (didAdd) {
                    stack.m_41774_(1);
                }
            }
            if (!didAdd) {
                player.m_6352_((Component)new TranslatableComponent("ars_nouveau.warp_scroll.inv_full"), Util.f_137441_);
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            player.m_6352_((Component)new TranslatableComponent("ars_nouveau.warp_scroll.recorded"), Util.f_137441_);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public void setTeleportTag(ItemStack stack, BlockPos pos, String dimension) {
        stack.m_41783_().m_128405_("x", pos.m_123341_());
        stack.m_41783_().m_128405_("y", pos.m_123342_());
        stack.m_41783_().m_128405_("z", pos.m_123343_());
        stack.m_41783_().m_128359_("dim_2", dimension);
    }

    public static Vec2 getRotationVector(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        return new Vec2(tag.m_128457_("xRot"), tag.m_128457_("yRot"));
    }

    public static void setRotationVector(ItemStack stack, Vec2 vector2f) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128350_("xRot", vector2f.f_82470_);
        tag.m_128350_("yRot", vector2f.f_82471_);
    }

    public static BlockPos getPos(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        return new BlockPos(tag.m_128451_("x"), tag.m_128451_("y"), tag.m_128451_("z"));
    }

    public String getDimension(ItemStack stack) {
        return stack.m_41784_().m_128461_("dim_2");
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag p_77624_4_) {
        BlockPos pos = WarpScroll.getPos(stack);
        if (pos.equals((Object)BlockPos.f_121853_)) {
            tooltip.add((Component)new TranslatableComponent("ars_nouveau.warp_scroll.no_location"));
            return;
        }
        tooltip.add((Component)new TranslatableComponent("ars_nouveau.position", new Object[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()}));
    }
}

